﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.App" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Types" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Sprzedaż</title>
    <script runat="server">

    ParametryWydrukuDokumentuZKodamiKreskowymi parametry;
    [Context]
    public ParametryWydrukuDokumentuZKodamiKreskowymi Parametry {
        get { return parametry; }
        set { parametry = value; }
    }

    bool LeftAlign = true;
		        
    void OnContextLoad(Object sender, EventArgs args) {
        DataRepeater1.DataSource = (IEnumerable)Parametry;
        DokumentHandlowy dokument = Parametry.Dokument;

        // Mateusz - task 12253 - 8.1
        if( dokument.Korekta ) {
            Ilosc.Caption = "Zmiana ilości";
            Wartosc.Caption = "Zmiana wartości";
        }

		dc.AdditionalFooterInfo = dokument.Definicja.InformacjeKRS;
		
        SectionDokumentHandlowy.Visible = dokument.DokumentHandlowyNumer!="";
        SectionMagazyn.Visible = dokument.Magazyn!=null && dokument.MagazynDo==null;
        SectionMagazynDo.Visible = dokument.MagazynDo!=null;
        
        //kody kreskowe
        ReportHeader1.WithBarcode = Parametry.NumerJakoKod;
        if( Parametry.NumerJakoKod ) {
            ReportHeader1.BarcodeFontSize = Parametry.RozmiarKoduNaglowka;
            ReportHeader1.BarcodeFontType = Parametry.TypCzcionkiNagłówka;
            ReportHeader1.BarcodeMethodGeneration = BarcodeGenerator.ZXing;
        }
        
        EANColumn.BarcodeFontType = Parametry.TypCzcionkiEAN;
        EANColumn.BarcodeFontSize = Parametry.RozmiarKoduNaLiniach;
        EANColumn.OnlyBarcode = !Parametry.KodPodpis;
        //Formatujemy informację o podmiocie
        if (dokument.Kontrahent==null)
            SectionKontrahent.Visible = false;
        else {
            if (dokument.Wydruk.JestOdbiorca)
				kto2.EditValue = "Kontrahent";
			else
				kto2.EditValue = dokument.Definicja.DostawcaOdbiorca;
        }
    
        //Składamy opis do dokumentu
        string opis = "";
        if (dokument.Opis!="")
            opis += "<p>" + dokument.Opis + "</p>";
        if (dokument.Wydruk.OpisWydruku!="")
            opis += "<p>" + dokument.Wydruk.OpisWydruku + "</p>";
        Opis.EditValue = opis;
    
        //Formatujemy podpisy
        stPodpis.Caption = "<font size=1>Dokument wystawił: </font><font size=2>"+dokument.Wydruk.UprawnionyDoWystawienia.FullName+"</font><br><br><font size=1>..................................................<br>Podpis osoby uprawnionej do wystawienia dokumentu</font>";
        stOsoba.Caption = "<font size=2>"+dokument.Osoba+"</font><br><br><font size=1>..................................................<br>Podpis osoby upoważnionej do otrzymania dokumentu</font>";

        switch (dokument.LiczonaOd)
        {
            case SposobLiczeniaVAT.OdBrutto:
            case SposobLiczeniaVAT.OdBruttoMinusNetto:
                {
                    Cena.Caption += " brutto";
                    Wartosc.Caption += " brutto";
                    break;
                }
            case SposobLiczeniaVAT.OdNetto:
                {
                    Cena.Caption += " netto";
                    Wartosc.Caption += " netto";
                    break;
                }
        }

        Grid1_RabatP.Visible = Grid1_CenaPrzedRabatem.Visible = dokument.JestRabat && dokument.Definicja.DrukowanieCenyIRabatu && !dokument.Definicja.CenaWartosc0;
		DataLabel15.EditValue = dokument.LiczonaOd == SposobLiczeniaVAT.OdNetto ? dokument.Suma.Netto : dokument.Suma.Brutto;
    }
    
    void DataRepeater1_BeforeRow(Object sender, EventArgs args) {
        //Formatujemy nagłówek dokumentu.
        //Może być za każdym razem inny
        KopiaDokumentu kopia = (KopiaDokumentu)DataRepeater1.CurrentRow;
        DokumentHandlowy dokument = kopia.Dokument;
        string title = dokument.Definicja.TytulWydruku;
        if (title!="")
            title += " ";
        title += dokument.Numer;
        if (dokument.Wydruk.OpisStanu!="")
			title += "|" + dokument.Wydruk.OpisStanu;        

        title += "|</STRONG>Data i miejsce wystawienia:<STRONG> " + dokument.Data + ", " + (dokument.Wydruk.JestOddzial ? dokument.Wydruk.PieczatkaOddziału.Adres.Miejscowosc : CoreModule.GetInstance(dokument).Config.Firma.AdresSiedziby.Miejscowosc);
        title += "|</STRONG>Data operacji:<STRONG> " + dokument.DataOperacji;
    
        ReportHeader1.Title = title;
    }
    
	void Grid1_OnBeforeRow( Object sender, RowEventArgs args ) 
	{
        PozycjaDokHandlowego poz = (PozycjaDokHandlowego)args.Row;
        EANColumn.EditValue = poz.Towar.GetKodKreskowy( Parametry.KodPozycjiBranyZ );
        EANColumn.Align = LeftAlign ? HorizontalAlign.Left : HorizontalAlign.Right;
        LeftAlign = !LeftAlign;
		if(!section15.Visible) 
            if((poz).WartoscCy.Symbol != "PLN")
                section15.Visible = true;
    }

    </script>
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>

<body>
    <form id="Sprzedaż" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" typename="Soneta.Handel.DokumentHandlowy,Soneta.Handel"
            oncontextload="OnContextLoad"></ea:datacontext>
        <ea:datarepeater id="DataRepeater1" runat="server" onbeforerow="DataRepeater1_BeforeRow"
            rowtypename="Soneta.Handel.KopiaDokumentu,Soneta.Handel" width="100%">
			<ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
			<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="true"></ea:PageBreak>
			<cc1:ReportHeader id="ReportHeader1" title="Magazyn" runat="server" WithBarcode="true" BarcodeMember="Dokument.Numer"></cc1:ReportHeader>

			<ea:Section id="SectionDokumentHandlowy" runat="server" Width="100%">
				<em>Dokument handlowy: </em>
				<ea:DataLabel id="DataLabel11" runat="server" DataMember="Dokument.DokumentHandlowyNumer" EncodeHTML="True"></ea:DataLabel>
				<em>&nbsp;z dnia:</em>
				<ea:DataLabel id="DataLabel13" runat="server" DataMember="Dokument.DokumentHandlowyData" EncodeHTML="True"></ea:DataLabel>
				<br />
			</ea:Section>
			<ea:Section id="SectionMagazyn" runat="server" Width="100%">
				<em>Magazyn: </em>
				<ea:DataLabel id="DataLabel1" runat="server" DataMember="Dokument.Magazyn" EncodeHTML="True"></ea:DataLabel>
				<br />
			</ea:Section>
			<ea:Section id="SectionMagazynDo" runat="server" Width="100%">
				<em>Z magazynu: </em>
				<ea:DataLabel id="DataLabel2" runat="server" DataMember="Dokument.Magazyn" EncodeHTML="True"></ea:DataLabel>
				<em>Do magazynu: </em>
				<ea:DataLabel id="DataLabel3" runat="server" DataMember="Dokument.MagazynDo" EncodeHTML="True"></ea:DataLabel>
				<br />
			</ea:Section>
			<ea:Section id="SectionKontrahent" runat="server" Width="100%">
				<em>
					<table id="Table1" cellspacing="0" width="100%">
						<tr>
							<td valign="top">
									<!-- Oddział firmy -->
                                    <ea:Section ID="OddzialFirmy" runat="server" 
				                        DataMember="Dokument.Wydruk.JestOddzial">
				                    <em style="text-decoration: underline;">Oddział:</em>
				                    <div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative;">
					                <ea:DataLabel ID="DataLabel42" runat="server" EncodeHTML="True" DataMember="Dokument.Wydruk.PieczatkaOddziału.Nazwa" ></ea:DataLabel><br />
					                <ea:DataLabel ID="DataLabel44" runat="server" EncodeHTML="True" Bold="false" DataMember="Dokument.Wydruk.PieczatkaOddziału.Adres.Linia1" ></ea:DataLabel><br />
					                <ea:DataLabel ID="DataLabel45" runat="server" EncodeHTML="True" Bold="false" DataMember="Dokument.Wydruk.PieczatkaOddziału.Adres.Linia2" ></ea:DataLabel>
				                    </div>
                                    </ea:Section>
                                    <!-- Oddział firmy -->
							</td>
							<td valign="top">
								<em style="text-decoration: underline;">
									<ea:DataLabel id="kto2" runat="server" Bold="False" Font-Italic="True" EncodeHTML="True"></ea:DataLabel>:</em><br />
								<div style="FONT-SIZE: 13px; LEFT: 10px; FONT-FAMILY: Tahoma; POSITION: relative">
									<ea:DataLabel id="DataLabel4" runat="server" DataMember="Dokument.DaneKontrahenta.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel><br />
									<ea:DataLabel id="DataLabel5" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><br />
									<ea:DataLabel id="DataLabel6" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><br />
									NIP:
									<ea:DataLabel id="DataLabel12" runat="server" Bold="False" DataMember="Dokument.DaneKontrahenta.EuVAT"></ea:DataLabel></div>								
								<ea:Section id="sectionOdbiorca" runat="server" DataMember="Dokument.Wydruk.JestOdbiorca">
									<em style="text-decoration: underline;">
										<ea:DataLabel id="kto" runat="server" Bold="False" Font-Italic="True" DataMember="Dokument.Definicja.DostawcaOdbiorca" EncodeHTML="True"></ea:DataLabel>:</em>
									<div style="FONT-SIZE: 13px; LEFT: 10px; FONT-FAMILY: Tahoma; POSITION: relative">
										<ea:DataLabel id="DataLabel10" runat="server" DataMember="Dokument.DaneOdbiorcy.NazwaFormatowana" EncodeHTML="True"></ea:DataLabel><br />
										<ea:DataLabel id="DataLabel9" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><br />
										<ea:DataLabel id="DataLabel8" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><br />
										NIP:
										<ea:DataLabel id="DataLabel7" runat="server" Bold="False" DataMember="Dokument.DaneOdbiorcy.EuVAT"></ea:DataLabel></div>
								</ea:Section>
								<ea:Section id="sectionMiejsceDostawy" runat="server" DataMember="Dokument.Wydruk.JestOdbiorcaMiejsceDostawy">
									<em style="text-decoration: underline;">Miejsce dostawy:</em>
									<div style="font-size: 13px; left: 10px; font-family: tahoma; position: relative">
										<ea:DataLabel id="DataLabel16" runat="server" DataMember="Dokument.OdbiorcaMiejsceDostawy.Nazwa" EncodeHTML="True"></ea:DataLabel><br />
										<ea:DataLabel id="DataLabel17" runat="server" Bold="False" DataMember="Dokument.OdbiorcaMiejsceDostawy.Adres.Linia1" EncodeHTML="True"></ea:DataLabel><br />
										<ea:DataLabel id="DataLabel18" runat="server" Bold="False" DataMember="Dokument.OdbiorcaMiejsceDostawy.Adres.Linia2" EncodeHTML="True"></ea:DataLabel><br />
									</div>
								</ea:Section>
							</td>
						</tr>
					</table>
				</em>
			</ea:Section>
				
			<div style="margin: 10px 0px 5px 0px">
				<ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Handel.PozycjaDokHandlowego,Soneta.Handel"
					DataMember="Dokument.Pozycje" RowsInRow="2" OnBeforeRow="Grid1_OnBeforeRow">
					<Columns>
						<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." RowSpan="2" runat="server"></ea:GridColumn>														
						<ea:GridColumn Width="20" DataMember="Towar.Kod" Caption="Kod towaru" RowSpan="1" runat="server" EncodeHTML="True"></ea:GridColumn>			
						<ea:GridColumn ID="EANColumn" runat="server" Caption=" " ColSpan="6" RowSpan="1" Align="Left" WithBarcode="Only" BarcodeFontType="EAN13Plus" BarcodeFontSize="36" BarcodeMethodGeneration="ZXing"></ea:GridColumn>							
						<ea:GridColumn DataMember="NazwaPierwszaLinia" Total="Info" Caption="Nazwa towaru" runat="server" EncodeHTML="True"></ea:GridColumn>						
						<ea:GridColumn ID="Grid1_CenaPrzedRabatem" runat="server"  DataMember="Cena" Width="15" RowSpan="2" Caption="Cena przed rabatem" Align="Right"> </ea:GridColumn>
						<ea:GridColumn ID="Grid1_RabatP" runat="server"  DataMember="Rabat" Width="10" RowSpan="2" Caption="Rabat %" Align="Right"> </ea:GridColumn>
						<ea:GridColumn Width="15" ID="Cena" Align="Right" DataMember="CenaPoRabacie" Caption="Cena" RowSpan="1" runat="server"></ea:GridColumn>						
						<ea:GridColumn Width="10" RightBorder="None" Align="Right" DataMember="ZmianaIlości.Value" Caption="Ilość" ID="Ilosc" RowSpan="1" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="5" Align="Center" DataMember="Ilosc.Symbol" Caption="jm." RowSpan="1" runat="server"></ea:GridColumn>
						<ea:GridColumn Width="15" Align="Right" DataMember="ZmianaWartościCy" Total="Sum" Caption="Wartość" ID="Wartosc" RowSpan="1" runat="server"></ea:GridColumn>
					</Columns>
				</ea:Grid>
			</div>
                
			<div style="margin: 5px 0px 10px 0px">
				Podsumowanie ilości:
				<ea:DataLabel id="DataLabel14" runat="server" Bold="False" DataMember="Dokument.Wydruk.PodsumowanieIlości">
				</ea:DataLabel>
				<br />
				
				<ea:Section ID="section15" runat="server" Visible="false">
					Podsumowanie <%=Parametry.Dokument.LiczonaOd == SposobLiczeniaVAT.OdNetto ? "netto" : "brutto" %> w PLN:
					<ea:DataLabel id="DataLabel15" runat="server" Bold="False">
					</ea:DataLabel>
					<br />
				</ea:Section>
			</div>
				
			<ea:Section ID="sectionNumeryNadrzednych" runat="server" DataMember="Dokument.Wydruk.CzyDrukowacNumeryPowiazanych">
				<div style="margin: 5px 0px 5px 0px">
					<em>Dokumenty powiązane:</em>
					<div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
					<ea:DataLabel ID="labelNumeryNadrzednych" runat="server" DataMember="Dokument.Wydruk.NumeryNadrzędneZK" Bold="False">
					</ea:DataLabel>
					<ea:DataLabel ID="labelNumeryPodrzednych" runat="server" DataMember="Dokument.Wydruk.NumeryPodrzędneBK" Bold="False">
					</ea:DataLabel>
					</div>
				</div>
			</ea:Section>

			<ea:Section runat="server" DataMember="Dokument.Wydruk.CzyDrukowacNumeryKorekt">
				<div style="margin: 5px 0px 5px 0px">
					<em>Poprzednie korekty:</em>
					<div style="font-size: 13px; left: 10px; font-family: Tahoma; position: relative">
					<ea:DataLabel runat="server" DataMember="Dokument.Wydruk.NumeryPoprzednichKorekt"
						Bold="false">
					</ea:DataLabel>
					</div>
				</div>
			</ea:Section>
				
			<ea:DataLabel id="Opis" runat="server" Bold="False"></ea:DataLabel>
				
			<cc1:ReportFooter id="ReportFooter1" runat="server" Height="105px" TheEnd="False">
				<Subtitles>
					<cc1:FooterSubtitle runat="server" Caption="Operator" ID="stPodpis" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle runat="server" Caption="Osoba" ID="stOsoba" SubtitleType="CenterText" Width="50"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:ReportFooter>
				
			<ea:SectionMarker id="SectionMarker6" runat="server" SectionType="Footer"></ea:SectionMarker>
        </ea:datarepeater>
    </form>
</body>
</html>

